<?php
session_start();

require_once '../config/database.php';
require_once '../helper.php';
require_once '../controllers/TenantController.php';

// 🔽 Tambahkan autoloader class
spl_autoload_register(function ($class) {
    $paths = ['../controllers/', '../core/', '../models/'];
    foreach ($paths as $path) {
        $file = $path . $class . '.php';

        if (file_exists($file)) {
            require_once $file;
            return;
        }
    }
});
Route::add('/buat-prefix', 'TenantController@savePrefix');
Route::add('/', 'AuthController@login');
Route::add('/login', 'AuthController@login');
Route::add('/register', 'AuthController@register');
Route::add('/logout', 'AuthController@logout');
Route::add('/dashboard', 'DashboardController@index');

Route::dispatch();
