<?php
class Route
{
    private static $routes = [];

    public static function add($uri, $action)
    {
        self::$routes[$uri] = $action;
    }

    public static function dispatch()
    {
        $uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        $uri = rtrim($uri, '/') ?: '/';

        if (isset(self::$routes[$uri])) {
            $parts = explode('@', self::$routes[$uri]);
            $controller = new $parts[0];
            $method = $parts[1];
            $controller->$method();
        } else {
            http_response_code(404);
            echo "404 Not Found";
        }
    }
}
